# healthcheck-component

Opinionated configurable health checks for Ring.

Supports multiple checks in an application. Returns a detailed 200 response if 
all tests pass, and a detailed 500 response if any checks fail.

## Dependencies

Be aware that this lib depends on [Compojure API] rather than default Compojure.
This may or may not be your thing.

There is nothing specifically here in this lib that requires Compojure API, but
we're wrapping this endpoint in our Bridg projects. The dependency inclusion
prevents warnings in our higher-level projects.

## Lein Installation

[![Clojars Project](https://img.shields.io/clojars/v/bridg/healthcheck-component.svg)](https://clojars.org/bridg/healthcheck-component)

## Usage

Healthcheck provides a component record that can be used for configuration as
well as an Compojure route handler. It is easy to use this in your componentized
project. It works especially well with the amazingly simple [Duct][1].

### Configuration

Supported configuration:

```
- healthchecks:     A map of keyword check name and check-fn pairs.
- path:             The path of the healthcheck route. Default \"_health\"
```

A component is provided to handle configuration. The component can be provided
to the endpoint as configuration. It is expected that the component is named
`healthcheck`.

Of course, you are free to provide configuration without using component by
providing a configuration map directly to the endpoint handler:

```clj
(endpoint {:healthcheck
           {:config {:healthchecks default-healthchecks
                     :path         "_health"}}})
```

#### Using with Duct

Add the component and endpoint to your system map:

```edn
{:components
 {:app  duct.component.handler/handler-component
  :http ring.component.jetty/jetty-server
  :healthcheck healthcheck/healthcheck}
 :endpoints
 {:health healthcheck/endpoint}
 :dependencies
 {:http [:app]
  :app  [:health]
  :health [:healthcheck]}
 :config
 {:http {:port 3000}
  :healthcheck {:healthchecks #var healthcheck/default-healthchecks
                :path "_health"}}}
```

## License

Copyright © 2016 Bridg, Inc.

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.

[1]: https://github.com/duct-framework/duc://github.com/duct-framework/duct "Duct"
