(ns singularity.node
  (:use
    [clojure.data.json :only (write-json)])
  (:import
    java.io.PrintWriter))

(defprotocol Node
  "Models representing nodes on the Singularity graph should implement this."
  (as-meme [this] "Returns a representation of this object as a meme, for calls to Singularity."))

;; Broke this out of clojure.data.json, to support rendering our Node objects
;; TODO:  Clean this process up a bit...?
(defn write-json-object [m ^PrintWriter out escape-unicode?]
  (.print out \{)
  (loop [x m]
    (when (seq m)
      (let [[k v] (first x)]
        (when (nil? k)
          (throw (Exception. "JSON object keys cannot be nil/null")))
        (.print out \")
        (.print out (name k))
        (.print out \")
        (.print out \:)
        (write-json v out escape-unicode?))
      (let [nxt (next x)]
        (when (seq nxt)
          (.print out \,)
          (recur nxt)))))
  (.print out \}))


