/*
 * Decompiled with CFR 0.152.
 */
package injectthedriver;

import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.Jsoner;
import injectthedriver.DriverFactoryException;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;

public class DriverFactory {
    public static Object createDriverFor(Class<?> itf) throws DriverFactoryException {
        return DriverFactory.createDriverFor(itf, System.getenv(), new ClassLoaderFactory());
    }

    static String envVarName(Class<?> itf) {
        return itf.getName().toUpperCase().replaceAll("[.]", "_");
    }

    static Map<String, Object> getProperties(Class<?> itf, Map<String, String> env) throws JsonException, DriverFactoryException {
        String s = env.get(DriverFactory.envVarName(itf));
        if (s == null) {
            throw new DriverFactoryException("Environment variable " + DriverFactory.envVarName(itf) + " missing");
        }
        return (Map)Jsoner.deserialize((String)s);
    }

    public static Object createDriverFor(Class<?> itf, Map<String, String> env, ClassLoaderFactory f) throws DriverFactoryException {
        Map<String, Object> props = DriverFactory.getProperties(itf, env);
        if (!props.containsKey("jar")) {
            throw new DriverFactoryException("Properties must contain a 'jar' attribute");
        }
        if (!props.containsKey("class")) {
            throw new DriverFactoryException("Properties must contain a 'class' attribute");
        }
        String jarPath = (String)props.get("jar");
        URL jarURL = new File(jarPath).toURI().toURL();
        ClassLoader cl = f.createClassLoader(jarURL);
        Class<?> cls = cl.loadClass((String)props.get("class"));
        Constructor<?> ctor = cls.getConstructor(Map.class);
        ClassLoader pcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Object obj = ctor.newInstance(props);
            Thread.currentThread().setContextClassLoader(pcl);
            return obj;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(pcl);
                throw throwable;
            }
            catch (JsonException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | MalformedURLException e) {
                throw new DriverFactoryException((Exception)e);
            }
        }
    }

    public static class ClassLoaderFactory {
        public ClassLoader createClassLoader(URL url) {
            return new URLClassLoader(new URL[]{url});
        }
    }
}

