(ns bss.rampant.utils
        (:refer-clojure :exclude [read-string])
                                   
  (:require       [clojure.edn :refer [read-string]]
                  [clojure.java.io :as io]
            [clojure.string :as str]
                                                     
                                                    
                              ))

(defn no-op [& _])

(defn group-by-deep [ks data]
  (if-not (seq ks)
    data
    (let [[k & ks'] ks]
      (->> (group-by k data)
           (map (fn [[idx data']] [idx (group-by-deep ks' data')]))
           (into {})))))

     
(defn safe-println
  "Threadsafe println. Useful for debugging and basic logging."
  [& more]
  (.write *out* (str (str/join " " more) "\n")))

     
(defn load-fixtures
  "Produce mapping of filenames to data, for EDN files in fixtures folder"
  ([] (load-fixtures "fixtures"))
  ([path]
   (let [f (io/file path)]
     (into {} (for [file (file-seq f)
                    :when (.endsWith (.getName file) ".edn")
                    :let [name (str/replace (.getName file) #".\w+$" "")]]
                [name (vec (read-string (slurp file)))])))))


(defn positions
  "Determine index positions in sequential collection where predicate holds"
  [pred coll]
  (keep-indexed (fn [idx x] (when (pred x) idx)) coll))

(defn frequencies-by
  "Returns a map from distinct items in coll to the number of times
  they appear."
  [f coll]
  (persistent!
   (reduce (fn [counts x]
             (let [v (f x)]
               (assoc! counts v (inc (get counts v 0)))))
           (transient {}) coll)))

(defn merge-by
  "Similar to merge-with, reduces elements over a collection grouped by
  key-fn and merges the value of val-fn as applied to each element with f.

      (merge-by + :year :sales [{:year 2014 :sales 20}
                                {:year 2014 :sales 50}
                                {:year 2015 :sales 10}])
      => {2014 70, 2015 10}"
  [f key-fn val-fn coll]
  (persistent!
    (reduce (fn [acc x]
              (let [v (key-fn x)]
                (assoc! acc v (f (get acc v 0) (val-fn x)))))
            (transient {}) coll)))


(defn- escape-char? [s]
  (some #{\, \" \return \newline} s))

(defn- escape-char [s]
  (str \" (str/escape s {\"       "\\\""
                         \return  "\\r"
                         \newline "\\n"})
       \"))

(defn- escape [s]
  (let [s (str s)]
    (if (escape-char? s) (escape-char s) s)))

(defn data->csv [data]
  (let [fields (keys (first data))]
    (str/join "\n"
              (cons
               (str/join "," (map (comp escape name) fields))
               (for [row data]
                 (str/join "," (map #(escape (get row %)) fields)))))))

      
              
                                                           
       
                                       

;; Dates

      
               
                                          
                               
                                       
                               
                               
                                       
                               
                                   
                                           
                                   
                                 
                                         
                                    

      
                         
                                                                               
                                               
                    
                                     
                                                           
                            

      
                                                                   

;; Debugging

(defn p [x] (prn x) x)
(defn p* [f & args] (let [v (apply f args)] (prn v) v))
(defn pc [xs] (prn (count xs)) xs)
(defn pc* [f & xs] (let [v (apply f xs)] (pc v) v))

;; UI Helpers

;; TODO: just use a (sq)uuid generator

(defonce ^:private last-id (atom 0))
(defn gen-id [] (swap! last-id inc))

(defn e->value [e]
  (-> e .-target .-value))

(defn glyphicon [type & body]
  (apply vector
         (keyword (str "span.glyphicon.glyphicon-" (name type)))
         body))

(defn right-glyphicon [type & body]
  (apply vector
         (keyword (str "span.right.glyphicon.glyphicon-" (name type)))
         body))

;; local storage

;; NOTE: pefer data to interface, replace usage of these helpers perhaps with:
;; https://github.com/dialelo/hodgepodge, transient-like direct usage
;; https://github.com/eneroth/plato, atom which syncs with mapped values
;; https://github.com/alandipert/storage-atom, atom which syncs as whole

      
                        
                                          
                                   

      
                               
                                             

      
                      
                                        
                   

      
                             
                                    

;; strings

(defn titlecase [string]
  (->> (str/split (name string) #" |-")
       (map (fn [s] (apply str (.toUpperCase (.substring s 0 1)) (.substring s 1))))
       (str/join " ")))

;; charting

      
                     
                                                                  
                          
        
                                  

;; AJAX

;; TODO: refactor these or use a library

      
                                   
                  
         
               
                          
                            
                                   
                        

      
                                
                                                                          

      
                         
                           
                                       

      
                                          
                           
                                     
               
                                    

      
                                         
                           
                                     
              
                                    

;;;;;;;;;;;; This file autogenerated from src-cljx/bss/rampant/utils.cljx
