(defproject bss/rampant "0.1.2-SNAPSHOT"
  :description "Common code"
  :url "http://github.com/braaisoft/rampant"
  :dependencies []
  :source-paths ["src", "src-cljx"]
  :jar-exclusions [#"\.cljx|\.swp|\.swo|\.DS_Store"]
  :repl-options {:nrepl-middleware
                 [cljx.repl-middleware/wrap-cljx
                  cemerick.piggieback/wrap-cljs-repl]},
  :repositories [["braai"   {:url "http://archiva.braaisoft.com/repository/snapshots/"}]
                 ["releases"{:url "http://archiva.braaisoft.com/repository/internal/"}]]
  :aliases {"test-all" ["do" "cljx" "once," "test," "cljsbuild" "test"]
            "cleantest" ["do" "clean," "test-all"]}
  :prep-tasks [["cljx" "once"] "javac" "compile"]
  :auto-clean false ;; allow the compiled cljx in jar
  :profiles {:dev {:plugins [[com.keminglabs/cljx "0.5.0" :exclusions [com.cemerick/piggieback]]
                             [com.cemerick/piggieback "0.1.5"]
                             [lein-pprint "1.1.2"]
                             [lein-cljsbuild "1.0.4"]]

                   :dependencies [[org.clojure/clojure "1.6.0"]
                                  [environ "1.0.0"]
                                  [org.clojure/clojurescript "0.0-2760"]
                                  [com.keminglabs/cljx "0.5.0" :exclusions [com.cemerick/piggieback]]
                                  [com.cemerick/piggieback "0.1.5"]]
                   :cljsbuild {:builds {:test {:source-paths ["target/classes", "test"]
                                               :compiler {:output-to     "target/tests.js"
                                                          :optimizations :whitespace
                                                          :pretty-print  true}}}
                               :test-commands {"unit" ["phantomjs"
                                                       "resources/phantom-shims.js"
                                                       "resources/unit-test.html"]}}}}
  :cljx {:builds [{:source-paths ["src-cljx"]
                   :output-path "target/classes"
                   :rules :clj}

                  {:source-paths ["src-cljx"]
                   :output-path "target/classes"
                   :rules :cljs}]})
