(ns camel-snake-kebab.extras
  (:require [clojure.walk :refer [postwalk]]))

(defn transform-keys [t coll]
  "Recursively transforms all map keys in coll with t."
  (letfn [(transform [[k v]] [(t k) v])]
    (postwalk (fn [x] (if (map? x) (into {} (map transform x)) x)) coll)))
;;;;;;;;;;;; This file autogenerated from src/camel_snake_kebab/extras.cljx
