(ns burningswell.api.client
  (:require [request.core :refer [      defroutes]])
                                                            )

(defroutes routes
  [;; Addresses
   {:path-params [:id]
    :path-parts ["" "addresses" :id]
    :path "/addresses/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/addresses/([^/]+)"
    :route-name :address}
   {:path-params []
    :path-parts ["" "addresses"]
    :path "/addresses"
    :method :get
    :path-re #"/addresses"
    :route-name :addresses}

   ;; Airports
   {:path-params [:id]
    :path-parts ["" "airports" :id]
    :path "/airports/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/airports/([^/]+)"
    :route-name :airport}
   {:path-params []
    :path-parts ["" "airports"]
    :path "/airports"
    :method :get
    :path-re #"/airports"
    :route-name :airports}
   {:path-params [:id]
    :path-parts ["" "continents" :id "airports"]
    :path "/continents/:id/airports"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/continents/([^/]+)/airports"
    :route-name :airports-in-continent}
   {:path-params [:id]
    :path-parts ["" "countries" :id "airports"]
    :path "/countries/:id/airports"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/countries/([^/]+)/airports"
    :route-name :airports-in-country}
   {:path-params [:id]
    :path-parts ["" "regions" :id "airports"]
    :path "/regions/:id/airports"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/regions/([^/]+)/airports"
    :route-name :airports-in-region}

   ;; Comments
   {:path-params [:id]
    :path-parts ["" "comments" :id]
    :path "/comments/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/comments/([^/]+)"
    :route-name :comment}
   {:path-params []
    :path-parts ["" "comments"]
    :path "/comments"
    :method :get
    :path-re #"/comments"
    :route-name :comments}

   ;; Continents
   {:path-params [:id]
    :path-parts ["" "continents" :id]
    :path "/continents/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/continents/([^/]+)"
    :route-name :continent}
   {:path-params []
    :path-parts ["" "continents"]
    :path "/continents"
    :method :get
    :path-re #"/continents"
    :route-name :continents}

   ;; Countries
   {:path-params []
    :path-parts ["" "countries"]
    :path "/countries"
    :method :get
    :path-re #"/countries"
    :route-name :countries}
   {:path-params [:id]
    :path-parts ["" "continents" :id "countries"]
    :path "/continents/:id/countries"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/continents/([^/]+)/countries"
    :route-name :countries-in-continent}
   {:path-params [:id]
    :path-parts ["" "countries" :id]
    :path "/countries/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/countries/([^/]+)"
    :route-name :country}

   ;; Images
   {:path-params [:id]
    :path-parts ["" "images" :id]
    :path "/images/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/images/([^/]+)"
    :route-name :image}
   {:path-params []
    :path-parts ["" "images"]
    :path "/images"
    :method :get
    :path-re #"/images"
    :route-name :images}

   ;; OAuth applications
   {:path-params [:id]
    :path-parts ["" "oauth" "applications" :id]
    :path "/oauth/applications/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/oauth/applications/([^/]+)"
    :route-name :oauth-application}
   {:path-params []
    :path-parts ["" "oauth" "applications"]
    :path "/oauth/applications"
    :method :get
    :path-re #"/oauth/applications"
    :route-name :oauth-applications}

   ;; Photos
   {:path-params [:id]
    :path-parts ["" "photos" :id]
    :path "/photos/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/photos/([^/]+)"
    :route-name :photo}
   {:path-params [:id]
    :path-parts ["" "photos" :id "images"]
    :path "/photos/:id/images"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/photos/([^/]+)/images"
    :route-name :photo-images}
   {:path-params []
    :path-parts ["" "photos"]
    :path "/photos"
    :method :get
    :path-re #"/photos"
    :route-name :photos}

   ;; Ports
   {:path-params [:id]
    :path-parts ["" "ports" :id]
    :path "/ports/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/ports/([^/]+)"
    :route-name :port}
   {:path-params []
    :path-parts ["" "ports"]
    :path "/ports"
    :method :get
    :path-re #"/ports"
    :route-name :ports}
   {:path-params [:id]
    :path-parts ["" "continents" :id "ports"]
    :path "/continents/:id/ports"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/continents/([^/]+)/ports"
    :route-name :ports-in-continent}
   {:path-params [:id]
    :path-parts ["" "countries" :id "ports"]
    :path "/countries/:id/ports"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/countries/([^/]+)/ports"
    :route-name :ports-in-country}
   {:path-params [:id]
    :path-parts ["" "regions" :id "ports"]
    :path "/regions/:id/ports"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/regions/([^/]+)/ports"
    :route-name :ports-in-region}

   ;; Regions
   {:path-params [:id]
    :path-parts ["" "regions" :id]
    :path "/regions/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/regions/([^/]+)"
    :route-name :region}
   {:path-params []
    :path-parts ["" "regions"]
    :path "/regions"
    :method :get
    :path-re #"/regions"
    :route-name :regions}
   {:path-params [:id]
    :path-parts ["" "continents" :id "regions"]
    :path "/continents/:id/regions"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/continents/([^/]+)/regions"
    :route-name :regions-in-continent}
   {:path-params [:id]
    :path-parts ["" "countries" :id "regions"]
    :path "/countries/:id/regions"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/countries/([^/]+)/regions"
    :route-name :regions-in-country}

   ;; Roles
   {:path-params [:id]
    :path-parts ["" "roles" :id]
    :path "/roles/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/roles/([^/]+)"
    :route-name :role}
   {:path-params []
    :path-parts ["" "roles"]
    :path "/roles"
    :method :get
    :path-re #"/roles"
    :route-name :roles}

   ;; Root
   {:path-params []
    :path-parts [""]
    :path "/"
    :method :get
    :path-re #"/"
    :route-name :root}

   ;; Search
   {:path-params []
    :path-parts ["" "search"]
    :path "/search"
    :method :get
    :path-re #"/search"
    :route-name :search}

   ;; Spots
   {:path-params [:id]
    :path-parts ["" "spots" :id]
    :path "/spots/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/spots/([^/]+)"
    :route-name :spot}

   {:path-params [:id]
    :path-parts ["" "spots" :id "spots-around"]
    :path "/spots/:id/spots-around"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/spots/([^/]+)/spots-around"
    :route-name :spots-around-spot}

   {:path-params [:id]
    :path-parts ["" "spots" :id "comments"]
    :path "/spots/:id/comments"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/spots/([^/]+)/comments"
    :route-name :spot-comments}
   {:path-params [:id]
    :path-parts ["" "spots" :id "photos"]
    :path "/spots/:id/photos"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/spots/([^/]+)/photos"
    :route-name :spot-photos}
   {:path-params [:id]
    :path-parts ["" "spots" :id "ratings"]
    :path "/spots/:id/ratings"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/spots/([^/]+)/ratings"
    :route-name :spot-ratings}
   {:path-params [:id]
    :path-parts ["" "spots" :id "sessions"]
    :path "/spots/:id/sessions"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/spots/([^/]+)/sessions"
    :route-name :spot-sessions}
   {:path-params [:id]
    :path-parts ["" "spots" :id "weather"]
    :path "/spots/:id/weather"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/spots/([^/]+)/weather"
    :route-name :spot-weather}
   {:path-params []
    :path-parts ["" "spots"]
    :path "/spots"
    :method :get
    :path-re #"/spots"
    :route-name :spots}
   {:path-params [:id]
    :path-parts ["" "continents" :id "spots"]
    :path "/continents/:id/spots"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/continents/([^/]+)/spots"
    :route-name :spots-in-continent}
   {:path-params [:id]
    :path-parts ["" "countries" :id "spots"]
    :path "/countries/:id/spots"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/countries/([^/]+)/spots"
    :route-name :spots-in-country}
   {:path-params [:id]
    :path-parts ["" "regions" :id "spots"]
    :path "/regions/:id/spots"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/regions/([^/]+)/spots"
    :route-name :spots-in-region}

   ;; Surfers
   {:path-params []
    :path-parts ["" "surfers" "me"]
    :path "/surfers/me"
    :method :get
    :path-re #"/surfers/me"
    :route-name :current-user}
   {:path-params [:id]
    :path-parts ["" "surfers" :id]
    :path "/surfers/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/surfers/([^/]+)"
    :route-name :user}
   {:path-params [:id]
    :path-parts ["" "surfers" :id "comments"]
    :path "/surfers/:id/comments"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/surfers/([^/]+)/comments"
    :route-name :user-comments}
   {:path-params [:id]
    :path-parts ["" "surfers" :id "followers"]
    :path "/surfers/:id/followers"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/surfers/([^/]+)/followers"
    :route-name :user-followers}
   {:path-params [:id]
    :path-parts ["" "surfers" :id "roles"]
    :path "/surfers/:id/roles"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/surfers/([^/]+)/roles"
    :route-name :user-roles}
   {:path-params []
    :path-parts ["" "surfers"]
    :path "/surfers"
    :method :get
    :path-re #"/surfers"
    :route-name :users}
   {:path-params [:id]
    :path-parts ["" "continents" :id "surfers"]
    :path "/continents/:id/surfers"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/continents/([^/]+)/surfers"
    :route-name :users-in-continent}
   {:path-params [:id]
    :path-parts ["" "countries" :id "surfers"]
    :path "/countries/:id/surfers"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/countries/([^/]+)/surfers"
    :route-name :users-in-country}
   {:path-params [:id]
    :path-parts ["" "regions" :id "surfers"]
    :path "/regions/:id/surfers"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/regions/([^/]+)/surfers"
    :route-name :users-in-region}

   ;; Weather datasets
   {:path-params [:id]
    :path-parts ["" "weather" "datasets" :id]
    :path "/weather/datasets/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/weather/datasets/([^/]+)"
    :route-name :weather-dataset}
   {:path-params []
    :path-parts ["" "weather" "datasets"]
    :path "/weather/datasets"
    :method :get
    :path-re #"/weather/datasets"
    :route-name :weather-datasets}
   {:path-params [:id]
    :path-parts ["" "weather" "models" :id "datasets"]
    :path "/weather/models/:id/datasets"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/weather/models/([^/]+)/datasets"
    :route-name :weather-datasets-by-model}
   {:path-params [:id]
    :path-parts ["" "weather" "variables" :id "datasets"]
    :path "/weather/variables/:id/datasets"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/weather/variables/([^/]+)/datasets"
    :route-name :weather-datasets-by-variable}

   ;; Weather models
   {:path-params [:id]
    :path-parts ["" "weather" "models" :id]
    :path "/weather/models/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/weather/models/([^/]+)"
    :route-name :weather-model}
   {:path-params []
    :path-parts ["" "weather" "models"]
    :path "/weather/models"
    :method :get
    :path-re #"/weather/models"
    :route-name :weather-models}
   {:path-params [:id]
    :path-parts ["" "weather" "variables" :id "models"]
    :path "/weather/variables/:id/models"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/weather/variables/([^/]+)/models"
    :route-name :weather-models-by-variable}

   ;; Weather variables
   {:path-params [:id]
    :path-parts ["" "weather" "variables" :id]
    :path "/weather/variables/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/weather/variables/([^/]+)"
    :route-name :weather-variable}
   {:path-params []
    :path-parts ["" "weather" "variables"]
    :path "/weather/variables"
    :method :get
    :path-re #"/weather/variables"
    :route-name :weather-variables}
   {:path-params [:id]
    :path-parts ["" "weather" "models" :id "variables"]
    :path "/weather/models/:id/variables"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/weather/models/([^/]+)/variables"
    :route-name :weather-variables-by-model}

   ;; Ratings
   {:path-params [:id]
    :path-parts ["" "ratings" :id]
    :path "/ratings/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/ratings/([^/]+)"
    :route-name :rating}
   {:path-params []
    :path-parts ["" "ratings"]
    :path "/ratings"
    :method :get
    :path-re #"/ratings"
    :route-name :ratings}

   ;; Sessions
   {:path-params [:id]
    :path-parts ["" "sessions" :id]
    :path "/sessions/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/sessions/([^/]+)"
    :route-name :session}
   {:path-params []
    :path-parts ["" "sessions"]
    :path "/sessions"
    :method :get
    :path-re #"/sessions"
    :route-name :sessions}]

  :scheme :https
  :server-name "api.burningswell.com"
  :server-port 443)

;;;;;;;;;;;; This file autogenerated from src/burningswell/api/client.cljx
