(ns burningswell.api.client
  (:require [geo.transit :as geo-transit]
            #?(:cljs [routes.core])
            #?(:clj [request.core :refer [defroutes]]
               :cljs [request.core :refer-macros [defroutes]])))

(def server
  {:scheme :https
   :server-name "api.burningswell.com"})

(def ^:private transit-opts
  #?(:clj
     {:encode {:handlers geo-transit/write-handlers}
      :decode {:handlers geo-transit/read-handlers}}
     :cljs
     {:encoding-opts {:handlers geo-transit/write-handlers}
      :decoding-opts {:handlers geo-transit/read-handlers}}))

(defroutes routes
  ["/" :root]
  ["/addresses" :addresses]
  ["/addresses/:id" :address]
  ["/airports" :airports]
  ["/airports/:id" :airport]
  ["/api" :api]
  ["/auth/jwt/token" :jwt-token]
  ["/comments" :comments]
  ["/comments/:id" :comment]
  ["/config" :config]
  ["/continents" :continents]
  ["/continents/:id" :continent]
  ["/continents/:id/airports" :airports-in-continent]
  ["/continents/:id/countries" :countries-in-continent]
  ["/continents/:id/ports" :ports-in-continent]
  ["/continents/:id/regions" :regions-in-continent]
  ["/continents/:id/spots" :spots-in-continent]
  ["/continents/:id/surfers" :users-in-continent]
  ["/countries" :countries]
  ["/countries/:id" :country]
  ["/countries/:id/airports" :airports-in-country]
  ["/countries/:id/image.png" :country-image]
  ["/countries/:id/ports" :ports-in-country]
  ["/countries/:id/regions" :regions-in-country]
  ["/countries/:id/spots" :spots-in-country]
  ["/countries/:id/surfers" :users-in-country]
  ["/images" :images]
  ["/images/:id" :image]
  ["/oauth/applications" :oauth-applications]
  ["/oauth/applications/:id" :oauth-application]
  ["/oauth/facebook/login" :oauth-facebook-login]
  ["/photos" :photos]
  ["/photos/:id" :photo]
  ["/photos/:id/likes" :photo-likes]
  ["/photos/:id/images" :photo-images]
  ["/ports" :ports]
  ["/ports/:id" :port]
  ["/ratings" :ratings]
  ["/ratings/:id" :rating]
  ["/regions" :regions]
  ["/regions/:id" :region]
  ["/regions/:id/airports" :airports-in-region]
  ["/regions/:id/image.png" :region-image]
  ["/regions/:id/ports" :ports-in-region]
  ["/regions/:id/spots" :spots-in-region]
  ["/regions/:id/surfers" :users-in-region]
  ["/roles" :roles]
  ["/roles/:id" :role]
  ["/search/autocomplete" :search-autocomplete]
  ["/search/details" :search-details]
  ["/sessions" :sessions]
  ["/sessions/:id" :session]
  ["/spots" :spots]
  ["/spots/:id" :spot]
  ["/spots/:id/comments" :spot-comments]
  ["/spots/:id/edit" :edit-spot]
  ["/spots/:id/photos" :spot-photos]
  ["/spots/:id/ratings" :spot-ratings]
  ["/spots/:id/sessions" :spot-sessions]
  ["/spots/:id/spots-around" :spots-around-spot]
  ["/spots/:id/weather" :spot-weather]
  ["/spots/new" :new-spot]
  ["/surfers" :users]
  ["/surfers/me" :me]
  ["/surfers/:id" :user]
  ["/surfers/:id/comments" :user-comments]
  ["/surfers/:id/followers" :user-followers]
  ["/surfers/:id/roles" :user-roles]
  ["/surfers/me" :current-user]
  ["/time-zones" :time-zones]
  ["/time-zones/:id" :time-zone]
  ["/weather/datasets" :weather-datasets]
  ["/weather/datasets/:id" :weather-dataset]
  ["/weather/models" :weather-models]
  ["/weather/models/:id" :weather-model]
  ["/weather/models/:id/datasets" :weather-datasets-by-model]
  ["/weather/models/:id/variables" :weather-variables-by-model]
  ["/weather/variables" :weather-variables]
  ["/weather/variables/:id" :weather-variable]
  ["/weather/variables/:id/datasets" :weather-datasets-by-variable]
  ["/weather/variables/:id/models" :weather-models-by-variable]
  {:accept "application/transit+json"
   :content-type "application/transit+json"
   :transit-opts transit-opts})
