(defproject burningswell/api-client "0.0.58"
  :description "The Burning Swell API client library."
  :url "https://github.com/burningswell/api-client"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :min-lein-version "2.0.0"
  :dependencies [[clj-http "3.5.0"]
                 [com.cognitect/transit-clj "0.8.300"]
                 [com.cognitect/transit-cljs "0.8.239"]
                 [geo-clj "0.6.2"]
                 [net.postgis/postgis-jdbc "2.2.1"
                  :exclusions [postgresql org.postgresql/postgresql]]
                 [org.clojure/clojure "1.8.0"]
                 [org.clojure/clojurescript "1.9.542" :scope "provided"]
                 [org.postgresql/postgresql "42.1.1"]
                 [request-clj "0.3.3"]]
  :aliases {"ci" ["do" ["test"] ["doo" "phantom" "test" "once"] ["lint"]]
            "lint" ["do"  ["eastwood"]]
            "test" ["do" ["test"] ["doo" "phantom" "test" "once"]]}
  :cljsbuild {:builds [{:id "test"
                        :compiler {:main 'burningswell.api.test
                                   :optimizations :none
                                   :output-to "target/testable.js"
                                   :pretty-print true}
                        :source-paths ["src" "test"]}]}
  :deploy-repositories [["releases" :clojars]]
  :checksum :ignore
  :profiles {:dev {:dependencies [[com.cemerick/piggieback "0.2.1"]
                                  [doo "0.1.7"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-cljsbuild "1.1.6"]
                             [lein-difftest "2.0.0"]
                             [lein-doo "0.1.7"]]}})
