(ns burningswell.api.authentication
  (:require [buddy.auth.backends.httpbasic :refer [http-basic-backend]]
            [buddy.auth.backends.token :refer [jws-backend]]
            [buddy.auth.middleware :as auth]
            [buddy.auth.middleware :as middleware]
            [buddy.auth.protocols :as proto]
            [burningswell.db.users :as users]
            [ring.util.response :refer [response response?]]))

(defn- db
  "Return the database from `request`."
  [request]
  (-> request :resources :db))

(defn- http-basic-auth-fn
  "The HTTP basic authentication fn."
  [request credentials]
  (users/authenticate (db request) credentials))

(defn- wrap-identity
  "Make sure that each request has an :identity key."
  [handler]
  (fn [request]
    (handler (update-in request [:identity] identity))))

(defn wrap-authentication
  "Wrap `handler` with authentication."
  [handler resources]
  (let [jws-secret (-> resources :config :jws :secret)]
    (-> (wrap-identity handler)
        (middleware/wrap-authentication
         (http-basic-backend
          {:realm "Burning Swell API"
           :authfn http-basic-auth-fn})
         (jws-backend {:secret jws-secret})))))
