(ns burningswell.api.jws
  (:require [buddy.sign.jws :as jws]
            [burningswell.api.schemas :refer :all]
            [burningswell.http.response :refer [created]]
            [clj-time.core :refer [now plus seconds]]
            [plumbing.core :refer :all]
            [schema.core :as s]))

(defn jws-claims
  "Return the JWS claims."
  [identity]
  {:id (:id identity)
   :username (:username identity)})

(defn jws-token
  "Return the JWS token for `identity`."
  [jws identity]
  {:token
   (jws/encode
    (jws-claims identity)
    (:secret jws)
    {:exp (plus (now) (seconds (:expires-in jws)))})})

(defnk $token$POST
  "Create a new JWS token."
  {:responses {201 s/Any}}
  [[:request identity :- User]
   [:resources jws]]
  (created (jws-token jws identity)))
