(ns burningswell.api.time-zones
  "The time zones of the world."
  (:require [burningswell.api.core :refer :all]
            [burningswell.api.schemas :refer :all]
            [burningswell.db.time-zones :as time-zones]
            [burningswell.http.response :refer [created ok]]
            [plumbing.core :refer :all]
            [schema.core :as s]))

(set! *warn-on-reflection* true)

(defn time-zone-not-found
  "Return a 404 response for a time-zone that could not be found by `id`."
  [id]
  (not-found (format "Time zone %s not found" id)))

(defnk $GET
  "List all time-zones."
  {:responses {200 [TimeZone]}}
  [[:request query-params :- PaginationParams]
   [:resources db]]
  (let [time-zones (time-zones/all db query-params)]
    (ok time-zones)))

(defnk $:id$GET
  "Show a time-zone."
  {:responses {200 TimeZone 404 NotFound}}
  [[:request
    [:uri-args id :- Id]
    query-params :- PaginationParams]
   [:resources db]]
  (if-let [time-zone (time-zones/by-id db id)]
    (ok time-zone)
    (time-zone-not-found id)))

(set! *warn-on-reflection* false)
