(ns burningswell.api.dislikes
  (:require [burningswell.api.middleware.authentication :as auth]
            [burningswell.api.middleware.conform :as conform]
            [burningswell.api.specs :as specs]
            [burningswell.api.validation :as v]
            [burningswell.db.photos :as photos]
            [claro.access :as access]
            [claro.data :as data]
            [clojure.spec.alpha :as s]))

(s/def :burningswell.api.dislikes/photo-id
  (s/and ::specs/id (v/db-id-exists? :photos)))

;; Dislike photo

(s/def :burningswell.api.dislike-photo/input
  (s/keys :req-un [:burningswell.api.dislikes/photo-id]))

(s/def :burningswell.api/dislike-photo
  (s/keys :req-un [:burningswell.api.dislike-photo/input]))

(defrecord DislikePhoto [input]
  access/Resolve
  (can-resolve? [params {:keys [user]}]
    (auth/is-authenticated user))

  conform/Params
  (conform [params env]
    :burningswell.api/dislike-photo)

  data/Mutation
  data/Resolvable
  (resolve! [params {:keys [db user]}]
    (photos/dislike! db user {:id (:photo-id input)})))

;; Undislike photo

(s/def :burningswell.api.undislike-photo/input
  (s/keys :req-un [:burningswell.api.dislikes/photo-id]))

(s/def :burningswell.api/undislike-photo
  (s/keys :req-un [:burningswell.api.undislike-photo/input]))

(defrecord UndislikePhoto [input]
  access/Resolve
  (can-resolve? [params {:keys [user]}]
    (auth/is-authenticated user))

  conform/Params
  (conform [params env]
    :burningswell.api/undislike-photo)

  data/Mutation
  data/Resolvable
  (resolve! [params {:keys [db user]}]
    (photos/undislike! db user {:id (:photo-id input)})))
