(ns burningswell.api.logger
  (:require [peripheral.core :refer [defcomponent]]
            [taoensso.timbre :as log]))

(defn- start
  "Start the logging component."
  [{:keys [level] :as log}]
  ;; Print more than the default 10 ex-data objects.
  (alter-var-root #'*print-length* (constantly 100))
  (log/set-level! level))

(defcomponent Logger [level previous]
  :this/as *this*
  :previous (:level log/*config*)
  :on/start (start *this*)
  :on/stop (log/set-level! previous))

(defn logger
  "Returns a logger componnent."
  [& [config]]
  (map->Logger config))
