(ns burningswell.api.middleware.identifier
  (:require [claro.engine :as engine]
            [claro.runtime.impl :as impl]
            [clojure.edn :as edn]
            [potemkin :refer [defprotocol+]]
            [ring.util.codec :as codec]))

(defprotocol+ Identifier
  (identifier [resolvable env]))

(extend-type Object
  Identifier
  (identifier [resolvable env]
    nil))

;; Transform output identifiers

(defn id [type obj & [{:keys [columns]}]]
  (-> (select-keys obj (or columns [:id]))
      (assoc :type type)
      (pr-str)
      (.getBytes)
      (codec/base64-encode)))

(defn- make-id [result type columns]
  (-> (select-keys result columns)
      (assoc :type type)
      (pr-str)
      (.getBytes)
      (codec/base64-encode)))

(defn parse-id [s]
  (some-> s codec/base64-decode (String.) edn/read-string))

(defn db-id [s]
  (:id (parse-id s)))

(defn- assoc-id [result type columns]
  (when-not (empty? result)
    (assoc result :id (make-id result type columns))))

(defn- transform-output
  [resolvable->result env]
  (->> (for [[resolvable result] resolvable->result
             :let [{:keys [type columns]} (identifier resolvable env)]]
         [resolvable
          (if (and type (not-empty columns))
            (assoc-id result type columns)
            result)])
       (into {})))

(defn wrap-output
  [engine]
  (let [impl (engine/impl engine)]
    (->> (fn [resolver]
           (fn [env batch]
             (impl/chain1
              impl
              (resolver env batch)
              #(transform-output % env))))
         (engine/wrap-transform engine))))
