(ns burningswell.api.signin
  (:require [burningswell.api.core :as core]
            [burningswell.api.jwt :as jwt]
            [burningswell.api.middleware.commands :as commands]
            [burningswell.api.middleware.events :as events]
            [burningswell.db.signin :as signin]
            [claro.data :as data]
            [clojure.spec.alpha :as s]))

(defn user-by-credentials
  "Sign in an existing user."
  [db credentials]
  (signin/by-credentials db credentials))

(defn signin! [env input]
  (let [user (user-by-credentials (:db env) input)]
    {:auth-token (some->> user (jwt/auth-token (:jwt env)))
     :user user}))

(defrecord Create [input]
  commands/Command
  (command [resolvable env]
    {:name :burningswell.api.commands/signin
     :params (assoc-in resolvable [:input :password] "<REMOVED>")})

  data/Mutation
  data/Resolvable
  (resolve! [_ env]
    (signin! env input))

  events/Events
  (events [resolvable env result]
    (if result
      [{:name :burningswell.api.events/signin-succeeded
        :user-id (-> result :user :id)}]
      [{:name :burningswell.api.events/signin-failed}])))
