(ns burningswell.api.time-zones
  (:require [burningswell.api.core :as core]
            [burningswell.api.middleware.conform :as conform]
            [burningswell.api.middleware.identifier :as identifier]
            [burningswell.api.specs :as specs]
            [burningswell.db.time-zones :as time-zones]
            [claro.data :as data]
            [clojure.spec.alpha :as s]))

(s/def :burningswell.api.time-zones/params
  (s/keys :opt-un [:burningswell.api.pagination/after
                   :burningswell.api.pagination/before
                   :burningswell.api.pagination/first
                   :burningswell.api.pagination/last
                   :burningswell.api.specs/direction
                   :burningswell.api.search/query
                   :burningswell.api.time-zones/sort]))

(defrecord TimeZone [id offset]
  conform/Params
  (conform [params env]
    (s/keys :req-un [:burningswell.api.specs/id]))

  identifier/Identifier
  (identifier [_ _]
    {:type :time-zone
     :columns [:id]})

  data/Resolvable
  data/BatchedResolvable
  (resolve-batch! [_ {:keys [db]} time-zones]
    (time-zones/select-batch db time-zones)))

(defrecord TimeZones [after before direction first last sort query]
  conform/Params
  (conform [params env]
    :burningswell.api.time-zones/params)

  data/Resolvable
  (resolve! [params {:keys [db]}]
    (->> {:direction direction
          :limit (core/limit params)
          :offset (core/offset params)
          :query query
          :sort sort}
         (time-zones/search db))))
