(ns burningswell.api.likes
  (:require [burningswell.api.middleware.conform :as conform]
            [burningswell.api.middleware.authentication :as auth]
            [burningswell.api.specs :as specs]
            [burningswell.api.validation :as v]
            [burningswell.db.photos :as photos]
            [claro.access :as access]
            [claro.data :as data]
            [clojure.spec.alpha :as s]))

(s/def :burningswell.api.likes/photo-id
  (s/and ::specs/id (v/db-id-exists? :photos)))

;; Like photo

(s/def :burningswell.api.like-photo/input
  (s/keys :req-un [:burningswell.api.likes/photo-id]))

(s/def :burningswell.api/like-photo
  (s/keys :req-un [:burningswell.api.like-photo/input]))

(defrecord LikePhoto [input]
  access/Resolve
  (can-resolve? [params {:keys [user]}]
    (auth/is-authenticated user))

  conform/Params
  (conform [params env]
    :burningswell.api/like-photo)

  data/Mutation
  data/Resolvable
  (resolve! [params {:keys [db user]}]
    (photos/like! db user {:id (:photo-id input)})))

;; Unlike photo

(s/def :burningswell.api.unlike-photo/input
  (s/keys :req-un [:burningswell.api.likes/photo-id]))

(s/def :burningswell.api/unlike-photo
  (s/keys :req-un [:burningswell.api.unlike-photo/input]))

(defrecord UnlikePhoto [input]
  access/Resolve
  (can-resolve? [params {:keys [user]}]
    (auth/is-authenticated user))

  conform/Params
  (conform [params env]
    :burningswell.api/unlike-photo)

  data/Mutation
  data/Resolvable
  (resolve! [params {:keys [db user]}]
    (photos/unlike! db user {:id (:photo-id input)})))
