(ns burningswell.api.middleware.transaction
  (:require [claro.data.protocols :as claro]
            [claro.engine :as engine]
            [datumbazo.core :as sql]
            [manifold.deferred :as d]))

(defn wrap-transaction
  "Middleware that wraps mutations into a database transaction."
  [engine]
  (->> (fn [resolver]
         (fn [{:keys [db] :as env} batch]
           (if (and (sql/db? db) (every? claro/mutation? batch))
             (sql/with-transaction [db db]
               (let [result (resolver (assoc env :db db) batch)]
                 (if (d/deferred? result)
                   @result result)))
             (resolver env batch))))
       (engine/wrap engine)))
