(ns burningswell.api.passwords
  (:require [burningswell.api.core :as core]
            [burningswell.api.gen :as gens]
            [burningswell.api.middleware.commands :as commands]
            [burningswell.api.middleware.conform :as conform]
            [burningswell.api.middleware.events :as events]
            [burningswell.api.validation :as v]
            [burningswell.db.emails :as emails]
            [claro.data :as data]
            [clojure.spec.alpha :as s]))

;; ## Reset Password

(s/def :burningswell.api.passwords.reset.input/email
  (s/with-gen (s/and string? v/email-valid? v/email-exists?)
    (constantly gens/email)))

(s/def :burningswell.api.passwords.reset/input
  (s/keys :req-un [:burningswell.api.passwords.reset.input/email]))

(s/def :burningswell.api.passwords/reset
  (s/keys :req-un [:burningswell.api.passwords.reset/input]))

(defrecord Reset [input]
  commands/Command
  (command [resolvable env]
    {:name :burningswell.api.commands.passwords/reset
     :params resolvable})

  conform/Params
  (conform [params env]
    :burningswell.api.passwords/reset)

  data/Mutation
  data/Resolvable
  (resolve! [params {:keys [db]}]
    (first (emails/by-address db (:email input))))

  events/Events
  (events [resolvable env result]
    (when result
      [{:name :burningswell.api.events.passwords/reset
        :email-id (:id result)}])))
