(ns burningswell.api.search
  (:require [burningswell.api.spots :refer [enhance-spots]]
            [burningswell.db.search :as search]
            [burningswell.db.util :refer [zip-by-id]]
            [burningswell.http.response :refer [ok]]
            [clojure.string :as str]))

(defn autocomplete
  "Auto-complete search."
  [{:keys [api-client db query-params]}]
  (ok (when-not (str/blank? (:query query-params))
        (search/autocomplete db query-params))))

(defn details
  "Detail search."
  [{:keys [api-client db query-params]}]
  (let [details (search/details db query-params)
        spots (filter #(= (:type %) :spot) details)
        spots (enhance-spots api-client db spots query-params)
        spots (zip-by-id spots)]
    (ok (map (fn [{:keys [id type] :as result}]
               (if (= type :spot)
                 (get spots id)
                 result))
             details))))
