(ns burningswell.api.time-zones
  "The time zones of the world."
  (:require [burningswell.api.hal :as hal]
            [burningswell.api.schemas :refer :all]
            [burningswell.db.time-zones :as time-zones]
            [burningswell.http.response :refer [ok]]))

(set! *warn-on-reflection* true)

(defn time-zone-not-found
  "Return a 404 response for a time-zone that could not be found by `id`."
  [id]
  (not-found (format "Time zone %s not found" id)))

(defn time-zones
  "List all time-zones."
  [{:keys [api-client db query-params]}]
  (let [time-zones (time-zones/all db query-params)]
    (ok (hal/links api-client :time-zone time-zones))))

(defn time-zone
  "Show a time-zone."
  [{:keys [api-client db path-params]}]
  (if-let [time-zone (time-zones/by-id db (:id path-params))]
    (ok (hal/link api-client :time-zone time-zone))
    (time-zone-not-found (:id path-params))))

(set! *warn-on-reflection* false)
