(ns burningswell.api.weather.forecasts
  (:require [burningswell.api.coerce :as coerce]
            [burningswell.api.schemas :refer :all]
            [burningswell.db.weather :as weather]
            [burningswell.http.response :refer [ok]]
            [geo.postgis :as geo]))

(defn forecasts
  "List the weather forecasts."
  [{:keys [api-client db query-params]}]
  (let [{:keys [latitude longitude] :as opts}
        (coerce/coerce WeatherForecastsParams query-params)
        location (geo/point 4326 longitude latitude)]
    (ok (weather/weather-forecast db location opts))))
