(ns burningswell.api.spec.user
  (:require [burningswell.api.spec.core :as core :refer :all]
            [clojure.spec :as s]))

(s/def ::email
  (s/and string?
         not-blank?
         email?
         email-available?))

(s/def ::username
  (s/and string?
         not-blank?
         (min-length 2)
         (max-length 32)
         username-available?))

(s/def ::password
  (s/and string?
         not-blank?
         (min-length 4)
         (max-length 1024)))

(s/def ::location ::core/location)

(s/def ::units
  (s/and string? units?))

(s/def ::signup
  (s/keys :req-un [::email ::username ::password]))

(s/def ::settings
  (s/keys :opt-un [::units]))

(s/def ::create-location
  (s/keys :req-un [::location]))
