(defproject burningswell/api "0.2.29"
  :description "The Burning Swell API"
  :url "https://bitbucket.org/burningswell/api"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[buddy/buddy-auth "1.3.0"]
                 [burningswell/api-client "0.0.53"]
                 [burningswell/config "0.1.39"]
                 [burningswell/core "0.0.49"]
                 [burningswell/db "0.0.111"]
                 [burningswell/geoip "0.1.0"]
                 [burningswell/http-server "0.1.10"]
                 [burningswell/pedestal "0.1.3"]
                 [burningswell/rabbitmq "0.3.2"]
                 [burningswell/transit "0.1.2"]
                 [ch.qos.logback/logback-classic "1.1.8"]
                 [funcool/clojure.jdbc "0.9.0"]
                 [geo-clj "0.6.2"]
                 [hal-clj "0.1.12"]
                 [hiccup "1.0.5"]
                 [org.clojure/clojure "1.9.0-alpha14"]
                 [org.clojure/core.cache "0.6.5"]
                 [prismatic/schema "1.1.3"]
                 [rm-hull/inkspot "0.2.1"]
                 [routes-clj "0.1.11"]
                 [tongue "0.2.0"]]
  :plugins [[lein-environ "1.1.0"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :eastwood {:config-files ["test-resources/eastwood.clj"]
             :exclude-linters [:deprecations
                               :local-shadows-var
                               :suspicious-expression]}
  :main ^{:skip-aot true} burningswell.api.main
  :profiles {:dev {:dependencies [[clj-http-fake "1.0.2"]
                                  [reloaded.repl "0.2.3"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-cloverage "1.0.9"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}
             :repl {:repl-options {:init-ns user}
                    :source-paths ["dev"]}
             :test {:resource-paths ["test-resources"]}
             :uberjar {:aot :all
                       :main burningswell.api.main
                       :resource-paths ["uberjar-resources"]}}
  :uberjar-name "burningswell-api.jar")
