(ns burningswell.api.jwt
  (:require [buddy.sign.jwt :as jwt]
            [burningswell.http.response :refer [created]]
            [clj-time.core :refer [now plus seconds]]))

(defn jwt-claims
  "Return the JWT claims."
  [identity]
  {:id (:id identity)
   :username (:username identity)})

(defn jwt-token
  "Return the JWT token for `identity`."
  [jwt identity]
  {:token
   (jwt/sign
    (jwt-claims identity)
    (:secret jwt)
    {:exp (plus (now) (seconds (:expires-in jwt)))})})

(defn create-token
  "Create a new JWT token."
  [{:keys [config identity]}]
  (created (jwt-token (:jwt config) identity)))
