(ns burningswell.api.core
  (:require [burningswell.api.spec.request :as request]
            [burningswell.rabbitmq.core :as rmq]
            [schema.core :as s])
  (:import [burningswell.rabbitmq.core RabbitMQ]))

(s/defn publish
  "Publish a message with `payload` to the API exchange using
  `routing-key`. "
  [broker :- RabbitMQ
   routing-key :- String
   payload :- s/Any & [opts]]
  (rmq/with-channel [channel broker]
    (rmq/publish channel "api" routing-key payload opts)
    payload))

(defn wrap-conform-request
  [func spec]
  (fn [request]
    (func (request/conform! spec request))))

(defn extract-request-spec
  [m]
  (and (map? m)
       (keyword? (:request m))
       (:request m)))

(defmacro defapi [name doc args meta & rest]
  (let [spec (or (extract-request-spec meta) any?)]
    `(do (defn ~name ~doc ~args ~meta ~@rest)
         (alter-var-root (var ~name) wrap-conform-request ~spec))))
