(ns burningswell.api.server
  (:require [burningswell.api.interceptors :as interceptors]
            [burningswell.api.routes :refer [routes]]
            [burningswell.pedestal.server :refer [server]]
            [com.stuartsierra.component :as component]
            [io.pedestal.http :as http]
            [io.pedestal.http.secure-headers :as secure-headers]
            [clojure.string :as str]))

(def secure-headers
  "The Pedestal secure content headers."
  {:content-security-policy-settings
   {:object-src "none"
    :script-src
    (->> ["'unsafe-inline'" interceptors/highlight-js]
         (str/join " "))
    :style-src
    (->> ["'self'" interceptors/highlight-css]
         (str/join " "))}})

(def dependencies
  "The API server component dependencies."
  [:api-client :broker :config :db :geoip :metrics :topology])

(defn new-api
  "Return a new API server."
  [& [config]]
  (-> (assoc config
             ::http/router :linear-search
             ::http/secure-headers secure-headers
             :init interceptors/add-interceptors
             :routes #(deref #'routes))
      (server)
      (component/using dependencies)))
