(ns burningswell.api.spec.country
  (:require [burningswell.api.spec.core :refer :all]
            [burningswell.api.spec.generators :as generators]
            [clojure.spec :as s]))

(s/def ::id
  (s/and pos-int?))

(s/def ::name
  (s/and string?
         not-blank?
         (min-length 2)
         (max-length 256)))

(s/def ::iso-3166-1-alpha-2
  (s/with-gen
    (s/and string?
           not-blank?
           (min-length 2)
           (max-length 2))
    (constantly generators/iso-3166-1-alpha-2)))

(s/def ::embedded
  (s/keys :req-un [::id ::name ::iso-3166-1-alpha-2]))
