(ns burningswell.config.spec
  "The Burning Swell configuration specs."
  (:require [clojure.spec.alpha :as s]))

(s/def ::bind-address string?)
(s/def ::bind-port pos-int?)
(s/def ::bootstrap-servers string?)
(s/def ::client-id string?)
(s/def ::client-secret string?)
(s/def ::password string?)
(s/def ::redirect-uri string?)
(s/def ::server-name string?)
(s/def ::server-port pos-int?)
(s/def ::url string?)
(s/def ::username string?)

;; API client

(s/def :burningswell.config.api-client/server-name ::server-name)
(s/def :burningswell.config.api-client/server-port ::server-port)
(s/def :burningswell.config.api-client/scheme #{:http :https})

(s/def :burningswell.config/api-client
  (s/keys :req-un [:burningswell.config.api-client/scheme
                   :burningswell.config.api-client/server-name
                   :burningswell.config.api-client/server-port]))

;; AWS

(s/def :burningswell.config.aws/access-key string?)
(s/def :burningswell.config.aws/account-number string?)
(s/def :burningswell.config.aws/secret-key string?)

(s/def :burningswell.config/aws
  (s/keys :req-un [:burningswell.config.aws/access-key
                   :burningswell.config.aws/account-number
                   :burningswell.config.aws/secret-key]))

;; Database

(s/def :burningswell.config.db/server-name ::server-name)
(s/def :burningswell.config.db/server-port ::server-port)
(s/def :burningswell.config.db/scheme #{:postgresql})
(s/def :burningswell.config.db/username ::username)
(s/def :burningswell.config.db/password ::password)
(s/def :burningswell.config.db/name string?)
(s/def :burningswell.config.db/test? boolean?)

(s/def :burningswell.config/db
  (s/keys :req-un [:burningswell.config.db/scheme
                   :burningswell.config.db/server-name
                   :burningswell.config.db/server-port
                   :burningswell.config.db/username
                   :burningswell.config.db/password
                   :burningswell.config.db/name
                   :burningswell.config.db/test?]))

;; Facebook

(s/def :burningswell.config.facebook/client-id ::client-id)
(s/def :burningswell.config.facebook/client-secret ::client-secret)
(s/def :burningswell.config.facebook/redirect-uri ::redirect-uri)

(s/def :burningswell.config/facebook
  (s/keys :req-un [:burningswell.config.facebook/client-id
                   :burningswell.config.facebook/client-secret
                   :burningswell.config.facebook/redirect-uri]))

;; Flickr

(s/def :burningswell.config.flickr/client-id ::client-id)
(s/def :burningswell.config.flickr/client-secret ::client-secret)
(s/def :burningswell.config.flickr/api-key string?)

(s/def :burningswell.config/flickr
  (s/keys :req-un [:burningswell.config.flickr/api-key
                   :burningswell.config.flickr/client-id
                   :burningswell.config.flickr/client-secret]))

;; Google Analytics

(s/def :burningswell.config.google.analytics/tracking-id string?)

(s/def :burningswell.config.google/analytics
  (s/keys :req-un [:burningswell.config.google.analytics/tracking-id]))

;; Google Maps

(s/def :burningswell.config.google.maps/api-key string?)

(s/def :burningswell.config.google/maps
  (s/keys :req-un [:burningswell.config.google.maps/api-key]))

;; Google Storage

(s/def :burningswell.config.google.storage/bucket string?)

(s/def :burningswell.config.google/storage
  (s/keys :req-un [:burningswell.config.google.storage/bucket]))

;; Google

(s/def :burningswell.config.google/redirect-uri ::redirect-uri)

(s/def :burningswell.config/google
  (s/keys :req-un [:burningswell.config.google/analytics
                   :burningswell.config.google/maps
                   :burningswell.config.google/storage
                   :burningswell.config.google/redirect-uri]))

;; Kafka

(s/def :burningswell.config.kafka/bootstrap.servers ::bootstrap-servers)

(s/def :burningswell.config/kafka
  (s/keys :req-un [:burningswell.config.kafka/bootstrap.servers]))

;; Linkedin

(s/def :burningswell.config.linkedin/client-id ::client-id)
(s/def :burningswell.config.linkedin/client-secret ::client-secret)

(s/def :burningswell.config/linkedin
  (s/keys :req-un [:burningswell.config.linkedin/client-id
                   :burningswell.config.linkedin/client-secret]))

;; Mapbox

(s/def :burningswell.config.mapbox/api-key string?)
(s/def :burningswell.config.mapbox/style string?)

(s/def :burningswell.config/mapbox
  (s/keys :req-un [:burningswell.config.mapbox/api-key
                   :burningswell.config.mapbox/style]))

;; Nrepl

(s/def :burningswell.config.nrepl/bind-address ::bind-address)
(s/def :burningswell.config.nrepl/bind-port (s/nilable ::bind-port))

(s/def :burningswell.config/nrepl
  (s/keys :req-un [:burningswell.config.nrepl/bind-address
                   :burningswell.config.nrepl/bind-port]))

;; JWT

(s/def :burningswell.config.jwt/expires-in pos-int?)
(s/def :burningswell.config.jwt/secret string?)

(s/def :burningswell.config/jwt
  (s/keys :req-un [:burningswell.config.jwt/expires-in
                   :burningswell.config.jwt/secret]))

;; Schema Registry

(s/def :burningswell.config.schema-registry/max-capacity pos-int?)
(s/def :burningswell.config.schema-registry/url ::url)

(s/def :burningswell.config/schema-registry
  (s/keys :req-un [:burningswell.config.schema-registry/max-capacity
                   :burningswell.config.schema-registry/url]))

;; S3 Backup

(s/def :burningswell.config.s3.backup/bucket string?)
(s/def :burningswell.config.s3.backup/prefix string?)

(s/def :burningswell.config.s3/backups
  (s/keys :req-un [:burningswell.config.s3.backup/bucket
                   :burningswell.config.s3.backup/prefix]))

;; S3 Photo

(s/def :burningswell.config.s3.photo/bucket string?)
(s/def :burningswell.config.s3.photo/prefix string?)

(s/def :burningswell.config.s3/photos
  (s/keys :req-un [:burningswell.config.s3.photo/bucket
                   :burningswell.config.s3.photo/prefix]))

;; S3

(s/def :burningswell.config/s3
  (s/keys :req-un [:burningswell.config.s3/backups
                   :burningswell.config.s3/photos]))

;; SMTP

(s/def :burningswell.config.smtp/server-name ::server-name)
(s/def :burningswell.config.smtp/server-port ::server-port)
(s/def :burningswell.config.smtp/scheme #{:smtp :smtps})
(s/def :burningswell.config.smtp/username ::username)
(s/def :burningswell.config.smtp/password ::password)

(s/def :burningswell.config/smtp
  (s/keys :req-un [:burningswell.config.smtp/scheme
                   :burningswell.config.smtp/server-name
                   :burningswell.config.smtp/server-port
                   :burningswell.config.smtp/username
                   :burningswell.config.smtp/password]))

;; Twitter

(s/def :burningswell.config.twitter/client-id ::client-id)
(s/def :burningswell.config.twitter/client-secret ::client-secret)

(s/def :burningswell.config/twitter
  (s/keys :req-un [:burningswell.config.twitter/client-id
                   :burningswell.config.twitter/client-secret]))

;; Photos

(s/def :burningswell.config.photos/bind-address ::bind-address)
(s/def :burningswell.config.photos/bind-port ::bind-port)
(s/def :burningswell.config.photos/scheme #{:http :https})
(s/def :burningswell.config.photos/server-name ::server-name)
(s/def :burningswell.config.photos/server-port ::server-port)
(s/def :burningswell.config.photos/version string?)

(s/def :burningswell.config/photos
  (s/keys :req-un [:burningswell.config.photos/bind-address
                   :burningswell.config.photos/bind-port
                   :burningswell.config.photos/scheme
                   :burningswell.config.photos/server-name
                   :burningswell.config.photos/server-port
                   :burningswell.config.photos/version]))

;; Web client

(s/def :burningswell.config.web-client/server-name ::server-name)
(s/def :burningswell.config.web-client/server-port ::server-port)
(s/def :burningswell.config.web-client/scheme #{:http :https})

(s/def :burningswell.config/web-client
  (s/keys :req-un [:burningswell.config.web-client/scheme
                   :burningswell.config.web-client/server-name
                   :burningswell.config.web-client/server-port]))

;; Backup

(s/def :burningswell.config.backup/aws :burningswell.config/aws)
(s/def :burningswell.config.backup/db :burningswell.config/db)
(s/def :burningswell.config.backup/s3 :burningswell.config.s3/backups)

(s/def :burningswell.config/backup
  (s/keys :req-un [:burningswell.config.backup/aws
                   :burningswell.config.backup/db
                   :burningswell.config.backup/s3]))

;; Web

(s/def :burningswell.config.web/api-client :burningswell.config/api-client)
(s/def :burningswell.config.web/async-js boolean?)
(s/def :burningswell.config.web/bind-address ::bind-address)
(s/def :burningswell.config.web/bind-port ::bind-port)
(s/def :burningswell.config.web/facebook :burningswell.config/facebook)
(s/def :burningswell.config.web/flickr :burningswell.config/flickr)
(s/def :burningswell.config.web/mapbox :burningswell.config/mapbox)
(s/def :burningswell.config.web/photos :burningswell.config/photos)
(s/def :burningswell.config.web/web-client :burningswell.config/web-client)

(s/def :burningswell.config/web
  (s/keys :req-un [:burningswell.config.web/api-client
                   :burningswell.config.web/async-js
                   :burningswell.config.web/bind-address
                   :burningswell.config.web/bind-port
                   :burningswell.config.web/facebook
                   :burningswell.config.web/flickr
                   :burningswell.config.web/mapbox
                   :burningswell.config.web/photos
                   :burningswell.config.web/web-client]))

;; API

(s/def :burningswell.config.api/api-client :burningswell.config/api-client)
(s/def :burningswell.config.api/bind-address ::bind-address)
(s/def :burningswell.config.api/bind-port ::bind-port)
(s/def :burningswell.config.api/db :burningswell.config/db)
(s/def :burningswell.config.api/facebook :burningswell.config/facebook)
(s/def :burningswell.config.api/flickr :burningswell.config/flickr)
(s/def :burningswell.config.api/google :burningswell.config/google)
(s/def :burningswell.config.api/jwt :burningswell.config/jwt)
(s/def :burningswell.config.api/kafka :burningswell.config/kafka)
(s/def :burningswell.config.api/photos :burningswell.config/photos)
(s/def :burningswell.config.api/web :burningswell.config/web-client)

(s/def :burningswell.config/api
  (s/keys :req-un [:burningswell.config.api/api-client
                   :burningswell.config.api/bind-address
                   :burningswell.config.api/bind-port
                   :burningswell.config.api/db
                   :burningswell.config.api/facebook
                   :burningswell.config.api/flickr
                   :burningswell.config.api/kafka
                   :burningswell.config.api/google
                   :burningswell.config.api/jwt
                   :burningswell.config.api/linkedin
                   :burningswell.config.api/photos
                   :burningswell.config.api/twitter
                   :burningswell.config.api/web]))

;; Config

(s/def :burningswell/config
  (s/keys :req-un [:burningswell.config/api-client
                   :burningswell.config/api
                   :burningswell.config/aws
                   :burningswell.config/db
                   :burningswell.config/facebook
                   :burningswell.config/flickr
                   :burningswell.config/google
                   :burningswell.config/kafka
                   :burningswell.config/photos
                   :burningswell.config/smtp
                   :burningswell.config/web
                   :burningswell.config/web-client]))
