(defproject burningswell/core "0.0.39"
  :description "The Burning Swell core library"
  :url "https://github.com/burningswell/core"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[cheshire "5.6.3"]
                 [clj-http "3.1.0"]
                 [clj-time "0.12.0"]
                 [com.cognitect/transit-clj "0.8.285"]
                 [com.stuartsierra/component "0.3.1"]
                 [enlive "1.1.6"]
                 [environ "1.0.3"]
                 [geo-clj "0.6.0"]
                 [geonames "0.6.8"]
                 [hal-clj "0.1.12"]
                 [net.postgis/postgis-jdbc "2.2.0" :exclusions [postgresql]]
                 [noencore "0.3.3"]
                 [ns-tracker "0.3.0"]
                 [org.clojure/clojure "1.8.0"]
                 [org.clojure/data.json "0.2.6"]
                 [org.clojure/test.check "0.9.0"]
                 [org.clojure/tools.logging "0.3.1"]
                 [org.clojure/tools.namespace "0.2.10"]
                 [org.postgresql/postgresql "9.4.1208"]]
  :plugins [[lein-environ "1.0.3"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]
            "test-ancient" ["test"]}
  :profiles {:dev {:plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}}
  :uberjar-name "burningswell-core.jar")
