(ns burningswell.shell
  (:require [clojure.java.shell :as sh]
            [clojure.string :as str]))

(defn sh! [& args]
  (let [{:keys [exit out err] :as result} (apply sh/sh args)]
    (when-not (zero? exit)
      (throw (ex-info (str "Can't execute shell command: "
                           (str/join " " args) "\n\n" err)
                      {:args args
                       :err err
                       :exit exit
                       :out out})))
    result))
