(ns burningswell.http.url
  (:import java.net.URLEncoder)
  (:refer-clojure :exclude (replace))
  (:use [clojure.string :only (blank? join replace)]))

(defprotocol QueryParameter
  (query-param [object]
    "Converts object to a query parameter."))

(extend-type nil
  QueryParameter
  (query-param [_]
    ""))

(extend-type clojure.lang.Keyword
  QueryParameter
  (query-param [keyword]
    (query-param (name keyword))))

(extend-type Object
  QueryParameter
  (query-param [object]
    (query-param (str object))))

(extend-type String
  QueryParameter
  (query-param [unencoded]
    (-> (URLEncoder/encode unencoded "UTF-8")
        (replace #"%2C" ",") ;; TODO: Keep commas?
        )))

(defn query-string [params]
  (join "&"
        (map (fn [[k v]]
               (let [k (query-param k) v (query-param v)]
                 (if (and (not (blank? k)) (not (blank? v)))
                   (str k "=" v))))
             params)))
