(ns burningswell.number)

(defn parse-double
  "Parse `string` as a double."
  [string & {:keys [junk-allowed]}]
  (if (number? string)
    (double string)
    (try (Double/parseDouble string)
         (catch Exception e
           (when-not junk-allowed
             (throw e))))))

(defn parse-float
  "Parse `string` as a float."
  [string & {:keys [junk-allowed]}]
  (if (number? string)
    (float string)
    (try (Float/parseFloat string)
         (catch Exception e
           (when-not junk-allowed
             (throw e))))))

(defn parse-integer
  "Parse `string` as a integer."
  [string & {:keys [junk-allowed radix]}]
  (if (integer? string)
    (int string)
    (try (Integer/parseInt (first (re-find #"([+-]?\d+)" string)) (or radix 10))
         (catch Exception e
           (when-not junk-allowed
             (throw e))))))

(defn parse-long
  "Parse `string` as a long."
  [string & {:keys [junk-allowed]}]
  (if (number? string)
    (long string)
    (try (Long/parseLong string)
         (catch Exception e
           (when-not junk-allowed
             (throw e))))))
