(ns burningswell.edn
  (:refer-clojure :exclude [read-string])
  (:require [clojure.edn :as edn]))

;; Read

(defn read-uri
  "Read an URI."
  [uri] (java.net.URI. uri))

(defn read-url
  "Read an URL."
  [url] (java.net.URL. url))

(def readers
  {'uri read-uri
   'url read-url})

(defn read-string [s & [opts]]
  (edn/read-string (merge {:readers readers} opts) s))

;; Print

(defn print-uri
  "Print an `java.net.URI`."
  [obj writer]
  (.write writer "#uri ")
  (.write writer (pr-str (str obj))))

(defn print-url
  "Print an `java.net.URL`."
  [obj writer]
  (.write writer "#url ")
  (.write writer (pr-str (str obj))))

(defmethod print-method java.net.URL
  [obj writer]
  (print-url obj writer))

(defmethod print-method java.net.URI
  [obj writer]
  (print-uri obj writer))
