(ns burningswell.edn
  (:refer-clojure :exclude [read-string prn-str])
  (:require [clojure.edn :as edn]
            [geo.postgis :as geo]))

;; Read

(defn read-uri
  "Read an URI."
  [uri] (java.net.URI. uri))

(defn read-url
  "Read an URL."
  [url] (java.net.URL. url))

(def readers
  (->> {'burningswell/uri read-uri
        'burningswell/url read-url}
       (merge geo/*readers*)))

(def read-opts
  "The default read options."
  {:readers readers})

(defn read-string
  "Like `edn/read-string` but "
  [s & [opts]]
  (edn/read-string (merge read-opts opts) s))

;; Print

(defn- print-tag-str
  "Print an `java.net.URI`."
  [tag obj writer]
  (.write writer (str tag " "))
  (.write writer (pr-str (str obj))))

(defn print-uri
  "Print an `java.net.URI`."
  [obj writer]
  (print-tag-str "#burningswell/uri" obj writer))

(defn print-url
  "Print an `java.net.URL`."
  [obj writer]
  (print-tag-str "#burningswell/url" obj writer))

(defmethod print-method java.net.URL
  [obj writer]
  (print-url obj writer))

(defmethod print-method java.net.URI
  [obj writer]
  (print-uri obj writer))

(defn prn-str
  "Returns `x` as a string printed as EDN."
  [x]
  (binding [*print-length* false
            *print-level* false]
    (clojure.core/prn-str x)))
