(ns burningswell.db.weather.datasources
  (:require [datumbazo.core :as sql :refer [column table]]
            [datumbazo.table :refer [deftable]]))

(deftable datasources
  "The weather datasources table."
  (table :weather.datasources)
  (column :id :serial :primary-key? true)
  (column :model-id :integer :not-null? true
          :references :weather.models/id)
  (column :das :text :not-null? true :unique? true)
  (column :dds :text :not-null? true :unique? true)
  (column :dods :text :not-null? true :unique? true)
  (column :created-at :timestamp :not-null? true)
  (column :updated-at :timestamp :not-null? true))
