-- Deploy add-user-settings-table

BEGIN;

CREATE TABLE "user-settings" (
  "id" SERIAL PRIMARY KEY,
  "user-id" INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE,
  "units" TEXT CHECK ("units" IS NULL OR "units" = ANY ('{eu, uk, us}'::text[])),
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE UNIQUE INDEX "user-settings-user-index" ON "user-settings"("user-id");

CREATE TRIGGER "user-settings-created-at-trigger"
  BEFORE INSERT ON "user-settings" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "user-settings-updated-at-trigger"
  BEFORE UPDATE ON "user-settings" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
