-- Deploy delete-images

BEGIN;

DROP VIEW "thumbnails";
DROP TABLE "images";

ALTER TABLE "photos" DROP COLUMN "spot-id";

ALTER TABLE "photos" ADD COLUMN "content-length" INTEGER CHECK ("content-length" >= 0);
ALTER TABLE "photos" ADD COLUMN "content-md5" TEXT;
ALTER TABLE "photos" ADD COLUMN "content-type" TEXT;
ALTER TABLE "photos" ADD COLUMN "height" INTEGER CHECK ("height" >= 0);
ALTER TABLE "photos" ADD COLUMN "original-url" TEXT;
ALTER TABLE "photos" ADD COLUMN "s3-key" TEXT;
ALTER TABLE "photos" ADD COLUMN "status" TEXT DEFAULT 'created';
ALTER TABLE "photos" ADD COLUMN "width" INTEGER CHECK ("width" >= 0);

ALTER TABLE "photos" ADD COLUMN "flickr-url" TEXT;
ALTER TABLE "photos" ADD COLUMN "flickr-owner-id" TEXT;
ALTER TABLE "photos" ADD COLUMN "flickr-owner-name" TEXT;
ALTER TABLE "photos" ADD COLUMN "flickr-owner-url" TEXT;

CREATE INDEX "photos-original-url-idx" ON "photos" ("original-url");

CREATE TABLE "photos-spots" (
  "photo-id" INTEGER NOT NULL REFERENCES "photos"("id") ON DELETE CASCADE,
  "spot-id" INTEGER NOT NULL REFERENCES "spots"("id") ON DELETE CASCADE,
  "user-id" INTEGER REFERENCES "users"("id") ON DELETE CASCADE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "photos-spots-photo-id-idx" ON "photos-spots" ("photo-id");
CREATE INDEX "photos-spots-spot-id-idx" ON "photos-spots" ("spot-id");
CREATE INDEX "photos-spots-user-id-idx" ON "photos-spots" ("user-id");

CREATE UNIQUE INDEX "photos-spots-photo-id-spot-ididx" ON "photos-spots" ("photo-id", "spot-id");

CREATE TRIGGER "photos-spots-created-at-trigger"
  BEFORE INSERT ON "photos-spots" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "photos-spots-updated-at-trigger"
  BEFORE UPDATE ON "photos-spots" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
