-- Deploy create-photo-labels-table

BEGIN;

CREATE TABLE "photo-labels" (
  "id" SERIAL PRIMARY KEY,
  "mid" TEXT NOT NULL UNIQUE,
  "description" CITEXT NOT NULL,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE TRIGGER "photo-labels-created-at-trigger"
  BEFORE INSERT ON "photo-labels" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "photo-labels-updated-at-trigger"
  BEFORE UPDATE ON "photo-labels" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
