-- Deploy create-spots-table

BEGIN;

CREATE TABLE "spots" (
  "id" SERIAL PRIMARY KEY,
  "country-id" INTEGER NOT NULL REFERENCES "countries"("id") ON DELETE CASCADE,
  "region-id" INTEGER REFERENCES "regions"("id") ON DELETE CASCADE,
  "user-id" INTEGER REFERENCES "users"("id") ON DELETE SET NULL,
  "name" CITEXT NOT NULL,
  "location" GEOMETRY(POINT, 4326),
  "visible" TEXT NOT NULL DEFAULT 'public',
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "spots-name-fulltext-index" ON "spots" USING gin(to_tsvector('english', "name"));
CREATE INDEX "spots-location-index" ON "spots" USING gist("location");
CREATE INDEX "spots-visible-index" ON "spots" ("visible");

CREATE TRIGGER "spots-created-at-trigger"
  BEFORE INSERT ON "spots" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "spots-updated-at-trigger"
  BEFORE UPDATE ON "spots" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
