-- Deploy create-daily-spot-forecasts-view

BEGIN;

CREATE OR REPLACE VIEW "weather"."daily-spot-forecasts" AS
    SELECT "spot-id", "model-id", "variable-id",
           avg("value") AS "value",
           max("reference-time") AS "reference-time",
           date("valid-time") AS "valid-time",
           min("created-at") AS "created-at",
           max("updated-at") AS "updated-at"
      FROM "weather"."spot-forecasts"
  GROUP BY "spot-id", "model-id", "variable-id", date("valid-time")
  ORDER BY "spot-id", date("valid-time");

COMMIT;
