--- Deploy create-addresses-table

BEGIN;

CREATE TABLE "addresses" (
  "id" SERIAL PRIMARY KEY,
  "country-id" INTEGER NOT NULL REFERENCES "countries"("id") ON DELETE CASCADE,
  "region-id" INTEGER REFERENCES "regions"("id") ON DELETE CASCADE,
  "formatted" CITEXT NOT NULL,
  "street-name" CITEXT,
  "street-number" CITEXT,
  "postal-code" CITEXT,
  "city" CITEXT,
  "location" GEOMETRY(POINT, 4326),
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "addresses-location-index" ON addresses USING gist(location);

CREATE TRIGGER "addresses-created-at-trigger"
  BEFORE INSERT ON "addresses" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "addresses-updated-at-trigger"
  BEFORE UPDATE ON "addresses" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
