-- Deploy create-weather-datasources

BEGIN;

CREATE TABLE "weather"."datasources" (
  "id" SERIAL PRIMARY KEY,
  "model-id" INTEGER NOT NULL REFERENCES "weather"."models"("id") ON DELETE CASCADE,
  "reference-time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "das" TEXT NOT NULL UNIQUE,
  "dds" TEXT NOT NULL UNIQUE,
  "dods" TEXT NOT NULL UNIQUE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE UNIQUE INDEX "weather-datasources-model-id-variable-id-filename-index" ON "weather"."datasources" ("model-id", "reference-time");

CREATE TRIGGER "weather-datasources-created-at-trigger"
  BEFORE INSERT ON "weather"."datasources" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "weather-datasources-updated-at-trigger"
  BEFORE UPDATE ON "weather"."datasources" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

ALTER TABLE "weather"."datasets" ADD COLUMN "datasource-id" INTEGER REFERENCES "weather"."datasources" ON DELETE CASCADE;

ALTER TABLE "weather"."datasets" DROP COLUMN "das";
ALTER TABLE "weather"."datasets" DROP COLUMN "dds";
ALTER TABLE "weather"."datasets" DROP COLUMN "dods";
ALTER TABLE "weather"."datasets" DROP COLUMN "download-finished-at";
ALTER TABLE "weather"."datasets" DROP COLUMN "download-started-at";
ALTER TABLE "weather"."datasets" DROP COLUMN "filename";
ALTER TABLE "weather"."datasets" DROP COLUMN "filesize";
ALTER TABLE "weather"."datasets" DROP COLUMN "model-id";
ALTER TABLE "weather"."datasets" DROP COLUMN "reference-time";

CREATE UNIQUE INDEX "weather-datasets-datasource-id-variable-id-valid-time-index" ON "weather"."datasets" ("datasource-id", "variable-id", "valid-time");

COMMIT;
