-- Deploy add-weather-raster-timestamps

BEGIN;

ALTER TABLE weather.rasters ADD COLUMN "model-id" INTEGER NOT NULL REFERENCES weather.models(id) ON DELETE CASCADE;
ALTER TABLE weather.rasters ADD COLUMN "variable-id" INTEGER NOT NULL REFERENCES weather.variables(id) ON DELETE CASCADE;
ALTER TABLE weather.rasters ADD COLUMN "valid-time" TIMESTAMP WITH TIME ZONE NOT NULL;
ALTER TABLE weather.rasters ADD COLUMN "reference-time" TIMESTAMP WITH TIME ZONE NOT NULL;

CREATE INDEX "weather-rasters-model-id-index" ON weather."rasters" ("model-id");
CREATE INDEX "weather-rasters-variable-id-index" ON weather."rasters" ("variable-id");
CREATE INDEX "weather-rasters-valid-time-index" ON weather."rasters" ("valid-time");

COMMIT;
