-- Deploy create-weather-spot-nowcasts-view

BEGIN;

CREATE MATERIALIZED VIEW weather."spot-nowcasts" AS
  SELECT DISTINCT ON ("spot-id", "variable-id") *
    FROM weather."spot-forecasts"
   WHERE "valid-time" >= now()
   ORDER BY "spot-id", "variable-id", "valid-time";

CREATE INDEX "weather-spot-nowcasts-spot-id" ON weather."spot-nowcasts" ("spot-id");
CREATE UNIQUE INDEX "weather-spot-nowcasts-spot-id-variable-id-valid-time" ON weather."spot-nowcasts" ("spot-id", "variable-id", "valid-time");

COMMIT;
