-- Revert remove-static-counter-cache-triggers

BEGIN;

CREATE OR REPLACE FUNCTION "update-airport-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-airport-count"();
  PERFORM "update-country-airport-count"();
  PERFORM "update-region-airport-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-airport-counts-on-delete-trigger"
  AFTER DELETE ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-airport-counts"();

CREATE TRIGGER "update-airport-counts-on-insert-trigger"
  AFTER INSERT ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-airport-counts"();

CREATE TRIGGER "update-airport-counts-on-update-trigger"
  AFTER UPDATE ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-airport-counts"();

CREATE OR REPLACE FUNCTION "update-country-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-country-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-country-counts-on-delete-trigger"
  AFTER DELETE ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-country-counts"();

CREATE TRIGGER "update-country-counts-on-insert-trigger"
  AFTER INSERT ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-country-counts"();

CREATE TRIGGER "update-country-counts-on-update-trigger"
  AFTER UPDATE ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-country-counts"();

CREATE OR REPLACE FUNCTION "update-port-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-port-count"();
  PERFORM "update-country-port-count"();
  PERFORM "update-region-port-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-port-counts-on-delete-trigger"
  AFTER DELETE ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-port-counts"();

CREATE TRIGGER "update-port-counts-on-insert-trigger"
  AFTER INSERT ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-port-counts"();

CREATE TRIGGER "update-port-counts-on-update-trigger"
  AFTER UPDATE ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-port-counts"();


CREATE OR REPLACE FUNCTION "update-region-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-region-count"();
  PERFORM "update-country-region-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-region-counts-on-delete-trigger"
  AFTER DELETE ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-region-counts"();

CREATE TRIGGER "update-region-counts-on-insert-trigger"
  AFTER INSERT ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-region-counts"();

CREATE TRIGGER "update-region-counts-on-update-trigger"
  AFTER UPDATE ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-region-counts"();

CREATE OR REPLACE FUNCTION "update-spot-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-spot-count"();
  PERFORM "update-country-spot-count"();
  PERFORM "update-region-spot-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-spot-counts-on-delete-trigger"
  AFTER DELETE ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-spot-counts"();

CREATE TRIGGER "update-spot-counts-on-insert-trigger"
  AFTER INSERT ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-spot-counts"();

CREATE TRIGGER "update-spot-counts-on-update-trigger"
  AFTER UPDATE ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-spot-counts"();

CREATE OR REPLACE FUNCTION "update-user-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-user-count"();
  PERFORM "update-country-user-count"();
  PERFORM "update-region-user-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-user-counts-on-delete-trigger"
  AFTER DELETE ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-user-counts"();

CREATE TRIGGER "update-user-counts-on-insert-trigger"
  AFTER INSERT ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-user-counts"();

CREATE TRIGGER "update-user-counts-on-update-trigger"
  AFTER UPDATE ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-user-counts"();

COMMIT;
