(ns burningswell.db.connection
  (:require [datumbazo.core :as d]
            [datumbazo.io :as io]))

(defn new-db [config]
  (d/new-db config))

(defmacro with-db
  "Eval `body` within the context of a database."
  [[db-sym config] & body]
  `(d/with-db [~db-sym (new-db ~config)]
     ~@body))

(comment
  (require '[environ.core :refer [env]])
  (require '[burningswell.config.core :as config])
  (with-db [db (assoc (config/db env) :name "burningswell_test")]
    (burningswell.db.spots/set-timezone db)))
