-- Deploy update-region-spot-count

BEGIN;

CREATE OR REPLACE FUNCTION "update-region-spot-count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE regions
     SET "spot-count" = u.count
    FROM (SELECT regions.id, count(spots.id)
            FROM regions
       LEFT JOIN spots
              ON spots."region-id" = regions.id
        GROUP BY regions.id) AS u
   WHERE regions.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
