-- Deploy create-followings-table

BEGIN;

CREATE TABLE followings (
  "id" SERIAL PRIMARY KEY,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "follower-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "accepted-at" TIMESTAMP WITH TIME ZONE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE UNIQUE INDEX "followings-user-id-follower-id-index" ON followings("user-id", "follower-id");
CREATE UNIQUE INDEX "followings-follower-id-user-id-index" ON followings("follower-id", "user-id");

CREATE TRIGGER "followings-created-at-trigger"
  BEFORE INSERT ON followings FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "followings-updated-at-trigger"
  BEFORE UPDATE ON followings FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
